define(['angular', 'app'], function (angular, app) {
	"use strict";

	app.service("connectionErrorService", function ($modal, $http, $q) {
		var service = {},
			modalInfo = {value: null, dismissed: true, resendHash: []},
			modalInstance,
			uniqueId = 0;

		var openModal = function (template, controller, modalInfo) {

			modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					}
				}
			});
		};

		var dismissModal = function () {
			if (angular.isDefined(modalInstance) && !modalInfo.dismissed) {
				modalInfo.dismissed = true;
				modalInstance.dismiss();
			}
		};

		service.run = function () {
			window.addEventListener("offline", function () {
				service.showConnectionErrorMsg();
			});
			window.addEventListener("online", function () {
				dismissModal();
			});
		};

		service.showConnectionErrorMsg = function () {
			dismissModal();
			openModal('src/core/connection/connection_error_template.html', ModalInstanceCtrl, modalInfo);
		};


		service.showServerErrorMsg = function (rejection) {
			var deferred = $q.defer();

			modalInfo.resendHash.push({rejection: rejection, deferred: deferred});

			if (modalInfo.dismissed) {
				openModal('src/core/connection/server_error_template.html', ModalInstanceCtrl, modalInfo);
			}

			return deferred.promise;
		};


		var ModalInstanceCtrl = function ($scope, $modalInstance, modalInfo, focusService) {
			modalInfo.dismissed = false;

			focusService.focusTopModal();

			$scope.ok = function () {
				$modalInstance.close();
				modalInfo.dismissed = true;
			};

			$scope.dismiss = function () {
				$modalInstance.dismiss();
				modalInfo.dismissed = true;

				var resendHash = modalInfo.resendHash;
				var resendHashLength = resendHash.length;
				for(var i = resendHashLength - 1; i >= 0; i--) {
					var resend = resendHash[i];
					resend.deferred.reject(resend.rejection);
					resendHash.splice(i, 1);
				}
				modalInstance.result.finally(function(){
					focusService.focusMain();
				});
			};

			$scope.retry = function () {
				$modalInstance.close();
				modalInfo.dismissed = true;

				var resendHash = modalInfo.resendHash;
				var resendHashLength = resendHash.length;
				for(var i = resendHashLength - 1; i >= 0; i--) {
					var resend = resendHash[i];
					$http(resend.rejection.config).success(function (data, status, headers, config) {
						resend.deferred.resolve({data: data, status: status, headers: headers, config: config});
					}).error(function (data, status, headers, config) {
						resend.deferred.reject({data: data, status: status, headers: headers, config: config});
					});
					resendHash.splice(i, 1);
				}
			};
		};

		return service;
	});
});